

//--------------
// tweaks
//--------------
	float2 ViewVec;
	float BlurOffset=0.02;
	float BlurWeights[9]={0,0.092,0.081,0.071,0.061,0.051,0.041,0.031,0.021};
	float BokehBrightness=0.5;

	const float samplesoffsetBilaterial[15] = { -14.0f,-12.0f,-10.0f,-8.0f, -6.0f, -4.0f, -2.0f, 0.0f, 2.0f, 4.0f, 6.0f, 8.0f,10.0f,12.0f,14.0f, }; 
	const float4 samplesColorBilaterial[15] = 
   {
{0.811764717102,0.509803950787,0.188235297799,0.486328125},
{0.823529422283,0.564705908298,0.278431385756,0.482421875},
{0.823529422283,0.564705908298,0.278431385756,0.482421875},
{0.976470589638,0.976470589638,0.96862745285,0.482421875},
{0.976470589638,0.976470589638,0.96862745285,0.482421875},
{1,1,1,1},
{1,1,1,1},
{1,1,1,1},
{1,1,1,1},
{1,1,1,1},
{0.929411768913,0.929411768913,0.929411768913,0.705078125},
{0.929411768913,0.929411768913,0.929411768913,0.705078125},
{0.729411780834,0.764705896378,0.890196084976,0.79296875},
{0.729411780834,0.764705896378,0.890196084976,0.79296875},
{0.32549020648,0.525490224361,0.772549033165,0.93359375}
};

	float Jitter;
	float ViewAspect;
	float LuminancePow=0.5;
//--------------
// Textures
//--------------
   texture ColorsampleTX <string Name = " ";>;
   sampler Colorsample=sampler_state 
      {
	Texture=<ColorsampleTX>;
   	ADDRESSU=CLAMP;
   	ADDRESSV=CLAMP;
   	ADDRESSW=CLAMP;   	
  	MagFilter=linear;
	MinFilter=linear;
	MipFilter=None;
      };
      
      
   texture BokehTX <string Name=" ";>;
   sampler Bokeh=sampler_state 
      {
	Texture=<BokehTX>;
  
      };         
      
//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION; 
     };
   struct OutPut
     {
	float4 OPos:POSITION; 
 	float2 Tex:TEXCOORD0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.OPos=IN.Pos; 
 	OUT.Tex=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewVec;
	return OUT;
    }

//--------------
// pixel shader
//--------------

     
  float4 PS_Bokeh(OutPut IN) : COLOR
     {
           
	float3 color = 0; 		
	float3 msum=0;
    float3 sum=0;    


	float noiseX = (frac(sin(dot(IN.Tex, float2(15.8989f, 76.132f)*1.0f))*46336.23745f)); 
	float noiseY = (frac(sin(dot(IN.Tex, float2(11.9899f, 62.223f)*2.0f))*34748.34744f)); 
	float noiseZ = (frac(sin(dot(IN.Tex, float2(13.3238f, 63.122f)*3.0f))*59998.47362f)); 
	float3 JitterDistort=(normalize(float3(noiseX, noiseY, noiseZ))-0.5)*Jitter; 

	//float Vignette=saturate(dot(IN.Tex-0.5,IN.Tex-0.5)*4+0.5)*BlurOffset;

        
	float2 direction = float2(0, 1); 
	for (int i = 1; i < 13; i++)
    	{     
		color = tex2D( Colorsample, IN.Tex + JitterDistort+direction*samplesoffsetBilaterial[i]*BlurOffset );            
		sum += color ; 
		color*=samplesColorBilaterial[i].xyz;
		msum = max(color,msum);
	}


	sum=sum /13;  
	float3 lum=saturate(pow(msum,LuminancePow));  	   
	return float4(lerp(sum.xyz, msum.xyz, saturate(BokehBrightness*lum )),1);   
	}

//--------------
// techniques   
//--------------
    technique Bokeh
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS(); 
 	PixelShader  = compile ps_3_0 PS_Bokeh(); 	
      }
      }